ORCA/M Asm65816 2.1.0

0001 0AC8              ;
0002 0AC8              ;
0003 0AC8              ;==================================================
0004 0AC8              ;          Read application's reserved
0005 0AC8              ;          LONG in window record.
0006 0AC8              ;==================================================
0007 0AC8              ;
0008 0AC8              ;   IN:    PUSH:LONG - pointer to window's port.
0009 0AC8              ;
0010 0AC8              ;  OUT:    LONG - application's reserved LONG,
0011 0AC8              ;                 set only by NewWindow and SetWRefCon.
0012 0AC8              ;
0013 0AC8              GetWRefCon PROC Export 
0014 0AC8              ; Change getWRefCon to not alter workptr. This is due to the listplus application
0015 0AC8              ; which calls GetWRefCon in its custom control procedure. Since the control happens to
0016 0AC8              ; be in the frame of the window, this was causing many window manager temps to be destroyed
0017 0AC8              ; that were not supposed to be destroyed in select window. Future versions of the window
0018 0AC8              ; manager should change selectwindow to save and restore needed vars around the call to 
0019 0AC8              ; drawentireframe.
0020 0AC8              ;
0021 0AC8              ; Stack for getWRefCon...
0022 0AC8              oldDPage equ   1
0023 0AC8              RTL1     equ   oldDPage+2
0024 0AC8              RTL2     equ   RTL1+3
0025 0AC8              TheWindow equ   RTL2+3
0026 0AC8              Result1  equ   TheWindow+4
0027 0AC8 0B                    phd                            ; save the callers dpage
0028 0AC9 3B                    tsc                            ; now use the stack as temp dpage
0029 0ACA 5B                    tcd   
0030 0ACB A0 AE 00              ldy   #wRefCon-4               ; offset to refcon (-4 cause this ain't window ptr)
0031 0ACE B7 09                 lda   [<theWindow],y           ; and get the data to return
0032 0AD0 85 0D                 sta   <result1
0033 0AD2 C8                    iny   
0034 0AD3 C8                    iny   
0035 0AD4 B7 09                 lda   [<theWindow],y
0036 0AD6 85 0F                 sta   <Result1+2
0037 0AD8              ; Since pop4Bytes might need something I don't know about at this late hour...
0038 0AD8 A5 07                 lda   RTL1+4                   ; move the return address
0039 0ADA 85 0B                 sta   RTL1+8                   ; down by 4 bytes
0040 0ADC
0041 0ADC A5 05                 lda   RTL1+2
0042 0ADE 85 09                 sta   RTL1+6
0043 0AE0
0044 0AE0 A5 03                 lda   RTL1
0045 0AE2 85 07                 sta   RTL1+4
0046 0AE4
0047 0AE4 2B                    pld                            ; recover the direct page
0048 0AE5
0049 0AE5 68                    pla                            ; strip off 4 bytes
0050 0AE6 68                    pla   
0051 0AE7 A9 00 00              lda   #0                       ; no errors possible
0052 0AEA 18                    clc                            ; clear the error flag
0053 0AEB 6B                    rtl                            ; and go home
0054 0AEC                       EndP 
0055 0AEC
0056 0AEC
0057 0AEC              ;============================
0058 0AEC              ;          Long call.
0059 0AEC              ;============================
0060 0AEC              ;
0061 0AEC              ;   IN:    x = middle WORD (bits 8-23) of address of destination routine.
0062 0AEC              ;          a = low WORD of address of destination routine.
0063 0AEC              ;
0064 0AEC              ;  OUT:    Calling this routine is the same as:
0065 0AEC              ;
0066 0AEC              ;                jsl   (ax)
0067 0AEC              ;
0068 0AEC              ;          where the low byte in 'a' is the low byte of the destination
0069 0AEC              ;          address, and x = the next 2 bytes of the destination address.
0070 0AEC              ;
0071 0AEC                       EXPORT longCall 
0072 0AEC              longCall PROC 
0073 0AEC              ;
0074 0AEC 3A                    dec   a                        Make low word look like a return address.
0075 0AED              ;                                   !!! High byte of address is not decremented
0076 0AED              ;                                       because the program counter doesn't wrap
0077 0AED              ;                                       to the next bank!!!!
0078 0AED              ;
0079 0AED DA                    phx                            Push the high byte.
0080 0AEE BA                    tsx                            Leave only the high byte of the address.
0081 0AEF E8                    inx   
0082 0AF0 9A                    txs   
0083 0AF1              ;
0084 0AF1 48                    pha                            Push the low word of the address.
0085 0AF2              ;
0086 0AF2 6B                    rtl                            Go to the address.
0087 0AF3              ;
0088 0AF3              ;  When the routine called returns, it
0089 0AF3              ;  will return to the routine that called 'longCall', not here.
0090 0AF3              ;
0091 0AF3                       ENDP 
